/**
* \file: Session.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTOT_SESSION_H
#define AAUTOT_SESSION_H

#include <string>
#include <aauto/GalReceiver.h>
#include <aauto/util/shared_ptr.h>
#include <aauto/util/Transport.h>
#include "VideoChannel.h"
#include "InputSourceChannel.h"
#include "SensorSourceChannel.h"
#include "AudioSinkChannel.h"
#include "AudioSourceChannel.h"
#include "NaviStatusChannel.h"
#include "MediaPlaybackStatusChannel.h"
#include "MediaBrowserChannel.h"
#include "aautoDemoIControllerCallbacks.h"
#include "UsbKeyboardInput.h"
#include "utils/IStoppable.h"
#include "utils/AAutoLayerManager.h"
#include "utils/IConfiguration.h"

namespace adit { namespace aauto {
    
class TestParameter
{
public:
    TestParameter()
    {
        testLocation = "";
    }
    std::string  getLocation() { return testLocation; }
    void setLocation(std::string inLocation) { testLocation = inLocation; }
private:
    std::string testLocation;
};

class Session : public IStoppable, public IKeyEventCallback
{
public:
    /* Session related functions */
    Session(IDynamicConfiguration& inConfig, const std::string inSerial);
    ~Session();

    bool Start();
    void Stop();

    /* Transport related functions */
    bool attachTransport(::shared_ptr<Transport> inTransport);
    void waitForExit();
    void requestStop();

    /* Test Keyboard related functions */
    void onKeyEventInput(uint32_t inInputCode, bool inPressed);
    void onKeyEventVideo(uint32_t inInputCode);
    void onKeyEventDeviceSelection(uint32_t inInputCode);
    void onKeyEventMediaAction(uint32_t inInputCode);

    /* Test layer management related functions */
    void setLayer(::shared_ptr<aautoLayerManager> inLayerManager, std::string inSerial)
    {
        layerManager = inLayerManager;
        serial = inSerial;
    }

    /* Test class related functions */
    void setTestParameter(TestParameter& inParameter) { testParameter = inParameter; }

    inline ::shared_ptr<GalReceiver> GetReceiver() { return receiver; }
    void sendByeByeRequest(void);
private:
    ::shared_ptr<GalReceiver> receiver;
    ::shared_ptr<AautoDemoIControllerCallbacks> callbacks;
    scoped_ptr<VideoChannel> video;
    scoped_ptr<InputSourceChannel> input;
    scoped_ptr<SensorSourceChannel> sensor;
    scoped_ptr<AudioSinkChannel> mediaAudio;
    scoped_ptr<AudioSinkChannel> systemAudio;
    scoped_ptr<AudioSinkChannel> navAudio;
    scoped_ptr<AudioSourceChannel> micAudio;
    scoped_ptr<USBKeyboardInput> keyboard;
    scoped_ptr<NaviStatusChannel> navi;
    scoped_ptr<MediaPlaybackStatusChannel> mediaPb;
    scoped_ptr<MediaBrowserChannel> mediaBs;
    ::shared_ptr<Transport> transport;
    ::shared_ptr<aautoLayerManager> layerManager;

    TestParameter testParameter;
    std::string serial;
    bool initReceiver();

    IDynamicConfiguration* mConfig;
    bool mUsbKeyboard;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_SESSION_H */
